## Ejemplo con Pygame
import pygame
from pygame.locals import *
from OpenGL.GL import *

def init():
    glShadeModel(GL_SMOOTH)
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glClearDepth(1.0)
    glDisable(GL_DEPTH_TEST)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)

def reshape((width, height)):
    if height == 0:
        height = 1
    glViewport(0, 0, width, height)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

def display():
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glColor3f(1.0, 0.0, 0.0)
    glBegin(GL_TRIANGLES)
    glVertex3f(0.0, 0.0, 0.0);
    glVertex3f(0.5, 0.5, 0.0);
    glVertex3f(0.5, 0.0, 0.0);
    glEnd()

def main():
    ## estas tres llamadas son a pygame
    pygame.init()
    pygame.display.set_mode((640,480), OPENGL|DOUBLEBUF)
    pygame.display.set_caption("Ejemplo OpenGL-PyGame")

    ## estas dos llamadas son a funciones propias
    reshape((640,480))
    init()

    run = True
    while run:
        for event in pygame.event.get():
            if event.type == QUIT:
                run = False
        ## esta es una llamada a una funcion propia
        display()
        ## estas dos llamadas son a pygame
        pygame.display.flip()
        pygame.time.wait(1000/30)

if __name__ == "__main__" :
    main()
